# -*- coding: utf-8 -*-
##############################################################################
# Copyright (c) 2015-Present Webkul Software Pvt. Ltd. (<https://webkul.com/>)
# See LICENSE file for full copyright and licensing details.
# License URL : <https://store.webkul.com/license.html/>
##############################################################################
from odoo import api, fields, models, _


class SeoUrlKeyWizard(models.TransientModel):
    _name = "seo.url.key.wizard"
    _description = "Seo Url Key Wizard"

    text = fields.Html(string='Message')
    warning_msg = fields.Boolean(string="Warn msg", default=False)

    def keep_original_keys(self):
        active_objs = False
        vals = {}
        if self._context.get('active_model'):
            active_ids = self._context.get('active_ids')
            if active_ids and self._context['active_model'] == 'product.template':
                active_objs = self.env['product.template'].search(
                    [('id', 'in', active_ids)])
                vals['pattern'] = 'pattern_product'
            elif active_ids and self._context['active_model'] == 'product.public.category':
                active_objs = self.env['product.public.category'].search(
                    [('id', 'in', active_ids)])
                vals['pattern'] = 'pattern_category'
            installed_langs = self.env['website.rewrite'].sudo(
            ).get_installed_langs()
            for lang in installed_langs:
                self.env['website.rewrite'].sudo().updateSeoUrlKey(
                    active_objs, lang.code, vals=vals)
            text = "SEO Url key of {} records have been successfully updated.".format(
                len(active_ids))
            return self.env['wk.wizard.message'].genrated_message(text)

    def set_to_draft(self):
        seo_rewrite_config_id = self.env.context.get('active_id')
        seo_config = self.env['seo.rewrite.config'].browse(
            seo_rewrite_config_id)
        seo_config.reset_to_draft()
