# -*- coding: utf-8 -*-
##########################################################################
#
#   Copyright (c) 2015-Present Webkul Software Pvt. Ltd. (<https://webkul.com/>)
#   See LICENSE file for full copyright and licensing details.
#   License URL : <https://store.webkul.com/license.html/>
#
##########################################################################

from odoo import api, models, http
from odoo.addons.http_routing.models import ir_http as httpRoutingObj
from odoo.addons.http_routing.models.ir_http import RequestUID
from odoo.addons.website.models.ir_http import ModelConverter
from odoo.addons.website.models.ir_http import Http as website_http
from odoo.addons.base.models.ir_qweb import keep_query
from odoo.addons.portal.controllers.portal import _build_url_w_params
from odoo import api, models
from odoo.http import request
from odoo.exceptions import AccessError, MissingError
from werkzeug.exceptions import (NotFound)
from odoo.addons.website.models.ir_http import Http as website_http
import werkzeug.exceptions
import logging
from odoo.osv import expression
_logger = logging.getLogger(__name__)

RESTRICTED_URLS = [
    '/web',
    '/shop/wishlist',
    '/favicon.ico',
    '/website/image',
    '/web/webclient/qweb',
    '/shop/checkout',
    '/shop/confirm_order',
    '/shop/cart/quantity',
    '/shop/cart',
    '/website/translations',
    '/shop/theme/change_pricelist/2',
    '/shop/theme/change_pricelist/1',
    '/robots.txt',
    '/web/login',
    '/web/bundle/',
    '/websocket',
    '/web/dataset/',
    '/jsonrpc',
    '/web/action/load',
    '/web/session/logout',
    '/mail/init_messaging',
    '/mail/load_message_failures',
    '/web/webclient/version_info',
    '/mail/inbox/messages',
    '/base_import/set_file',
    '/shop/products/recently_viewed_update',
    '/shop/products/recently_viewed_delete',
    '/shop/cart/update_option',
    '/shop/cart/update_json',
    '/shop/get_product_data',
    '/shop/carrier_rate_shipment',
    '/shop/update_carrier',
    '/shop/country_infos/',
    '/shop/address',
    '/shop/access_point/get',
    '/shop/save_shop_layout_mode',
    '/shop/pricelist',
    '/shop/config/website',
    '/shop/access_point/set',
    '/shop/access_point/get',
    '/shop/access_point/close_locations',
    '/shop/cart/clear',
    '/shop/cart/update_address',
    '/shop/extra_info',
    '/shop/payment/validate',
    '/shop/print',
    '/shop/config/product',
    '/shop/config/attribute',
    '/shop/compare',
    '/shop/claimreward',
    '/shop/add/stock_notification',
    '/shop/wishlist/add',
    '/shop',
    '/',
    '/shop/set_delivery_method',
    '/shop/get_delivery_rate',
    '/shop/update_address',
    '/shop/delivery_methods',
    '/shop/product/extra-images',
    '/shop/product/clear-images',
    '/shop/product/resequence-image',
    '/shop/product/is_add_to_cart_allowed'
    

]
AVOIDABLE_ROUTES = ['/web/dataset/call_kw',
                    '/bus/websocket_worker_bundle',
                    '/web/assets/',
                    'mail/thread/data',
                    '/web/dataset',
                    '/web/image',
                    '/web/content',
                    '/websocket/peek_notifications',
                    '/website/translations/',
                    '/web/bundle/',
                    '/website/iframefallback',
                    '/web/action/load',
                    '/my/home',
                    '/websocket/update_bus_presence',
                    '/website_mass_mailing/is_subscriber',
                    '/shop/cart',
                    '/shop/checkout',
                    '/confirm_order',
                    '/shop/payment',
                    '/shop/address',
                    '/shop/confirmation',
                    '/shop/country_infos',
                    '/shop/change_pricelist',
                    '/shop/city_infos',
                    '/shop/state_infos',
                    '/shop/payment/transaction/',
                    '/shop/wishlist/remove/',
                    '/blog/tag/',
                    '/shop/country_info',
                    '/shop/set_delivery_method',
                    '/shop/get_delivery_rate'
                    ]
MODEL_MAPPING = {'product.template': (
    'product', '/shop/'), 'product.public.category': ('category', '/shop/category')}


def _ignore_path_to_rewrite(req_page):
    return len([path for path in AVOIDABLE_ROUTES if path in req_page])


def slug(value):
    if not value:
        raise request.not_found()
    try:
        seo_conf = value.env['seo.rewrite.config'].sudo().search(
            [('state', '=', 'enabled'), ('seo_model', '=', MODEL_MAPPING.get(value._name, [False, False])[0])], limit=1)
    except Exception:
        seo_conf = False
    field = 'url_key'
    if seo_conf and field and isinstance(value, models.BaseModel) and hasattr(value, field):
        name = getattr(value, field)
        if name:
            suffix = getSuffix(value)
            return f"{name}{suffix}" if suffix else name
    return request.env['ir.http']._slug(value)


httpRoutingObj.slug = slug


def getSuffix(value):
    seo_config = value.env['seo.rewrite.config'].sudo().search(
        [('state', '=', 'enabled'), ('seo_model', '=', MODEL_MAPPING.get(value._name, [False, False])[0])], limit=1)
    use_suffix = seo_config.use_suffix
    suffix = use_suffix and seo_config.suffix_value or ''
    return suffix


class ModelConverterRewrite(ModelConverter):

    def __init__(self, url_map, model=False, domain='[]'):
        super(ModelConverter, self).__init__(url_map, model)
        self.domain = domain
        self.regex = r'(?:(\w{1,2}|\w[A-Za-z0-9-._]+?))(?=$|/)'

    def to_url(self, value):
        try:
            if value and hasattr(value, '_name') and value._name in list(MODEL_MAPPING.keys()):
                seo_conf = request.env['seo.rewrite.config'].sudo().search(
                    [('state', '=', 'enabled'), ('seo_model', '=', MODEL_MAPPING.get(value._name, ['', ''])[0])], limit=1)
                if not seo_conf:
                    return super().to_url(value)
                url = slug(value)
                if "/" in url:
                    url = url.replace('/', '__')
                return url
            return slug(value)
        except AccessError:
            pass
        return super().to_url(value)

    def to_python(self, value):
        seo_active = request.env['seo.rewrite.config'].sudo().search(
            [('state', '=', 'enabled'), ('seo_model', '=', MODEL_MAPPING.get(self.model, ['', ''])[0])], limit=1)
        if not seo_active:
            return super().to_python(value)
        value = self.unsetSuffix(value)
        _uid = RequestUID(value=value, converter=self)
        env = api.Environment(request.cr, _uid, request.context)
        record_id = None
        field = 'url_key'
        if field and field in env[self.model]._fields:
            current_lang = request.httprequest.cookies.get(
                'frontend_lang') or request.context.get('lang')
            res = request.env[self.model].sudo().with_context(lang=current_lang, active_test=False).search(
                [(field, '=', value.replace('__', '/'))])
            if res:
                record_id = res[0].id
        if not record_id:
            return super().to_python(value)
        if not record_id:
            return env[self.model]
        if record_id < 0:
            if not env[self.model].browse(record_id).exists():
                record_id = abs(record_id)
        return env[self.model].browse(record_id)

    def getUrlKeyModel(self, value):
        model = self.model
        value = value.replace('__', '/')
        searchKey = "/"+value
        redirectObj = request.env['website.rewrite'].sudo()
        res = redirectObj.search([('url_to', '=', searchKey)], 0, 1, 'id desc')
        if not res:
            modelName = redirectObj.getSlugUrlKeyModel(value, model)
            if modelName:
                model = modelName
        if res:
            if res.rewrite_val != 'custom':
                model = res.rewrite_val
        return model

    def unsetSuffix(self, value):
        value = request.env['website.rewrite'].sudo().unsetUrlSuffix(value)
        return value


class IrHttp(models.AbstractModel):
    _inherit = 'ir.http'

    @classmethod
    def _get_converters(cls):
        return dict(
            super(IrHttp, cls)._get_converters(),
            model=ModelConverterRewrite,
        )

    @classmethod
    def _get_lang_url_code(cls, code):
        lang = request.env['res.lang'].sudo().search([('code', '=', code)])
        if lang:
            return lang.url_code
        return code

    @classmethod
    def _get_cuurent_user_lang(cls):
        user_lang = request.httprequest.cookies.get('frontend_lang')
        if user_lang:
            return cls._get_lang_url_code(user_lang)
        return False

    @classmethod
    def _get_remove_lang_code(cls, path):
        lang_url_codes = [value.get(
            'url_code') for value in request.env['res.lang'].sudo()._get_frontend().values()]
        spath = path.split('/')
        lang = False
        try:
            index = lang_url_codes.index(spath[1])
            lang = lang_url_codes[index]
            spath.pop(1)
        except Exception:
            pass
        if not lang:
            lang = cls._get_cuurent_user_lang()
        return '/'.join(spath), lang

    @classmethod
    def _match(cls, path):
        try:
            skip_custom = request.context.get('skip_custom', False)
            if not skip_custom and not _ignore_path_to_rewrite(path) and path not in RESTRICTED_URLS and path != '/':
                path = cls._custom_seo_rewrite(path)
            # _logger.info("########### path matching after :: %r #######", path)
        except Exception as e:
            _logger.info(
                "########### path matching issue :: %r #######", str(e))
        return super()._match(path)

    @classmethod
    def _redirect_to_specified(cls, redirectUrl, redirect):
        request.reroute(redirectUrl)

        if not hasattr(request, 'rerouting'):
            request.rerouting = [request.httprequest.path]
        user_lang = redirect.lang_id.code
        request.update_context(lang=user_lang)
        request.is_frontend = True
        # request.lang = redirect.lang_id
        request.lang = request.env['res.lang']._get_data(code=(user_lang
                                                               ))
        request.is_frontend_multilang = True
        for key in ('full_path', 'url', 'base_url'):
            request.httprequest.__dict__.pop(key, None)
        return redirectUrl

    @classmethod
    def _serve_redirect(cls):
        res = super(IrHttp, cls)._serve_redirect()
        if res:
            return res
        req_page = request.httprequest.path
        if not _ignore_path_to_rewrite(req_page) and req_page not in RESTRICTED_URLS and req_page != '/':
            req_page_array = req_page.split(".")
            req_page = req_page_array[0] if len(req_page_array) else req_page
            if len(req_page_array) > 1:
                request.update_context(url_suffix="."+req_page_array[1])
        if '/shop' in req_page or '/shop/category' in req_page:
            domain = [
                ('redirect_type', 'in', ('301', '302')),
                # trailing / could have been removed by server_page
                '|', ('url_from', '=', req_page.rstrip('/')
                      ), ('url_from', '=', req_page + '/')
            ]
        else:
            domain = [
                ('redirect_type', 'in', ('301', '302')),
                # trailing / could have been removed by server_page
                '|', '|', '|', ('url_from', '=', '/shop'+req_page), ('url_from', '=', '/shop/category' +
                                                                     req_page), ('url_from', '=', req_page.rstrip('/')), ('url_from', '=', req_page + '/')
            ]
        domain += request.website.sudo().website_domain()
        return request.env['website.rewrite'].sudo().search(domain, limit=1)

    @classmethod
    def _all_seo_configure_status(cls):
        for value in MODEL_MAPPING.values():
            seo_config = request.env['seo.rewrite.config'].sudo().search(
                [('state', '=', 'enabled'), ('seo_model', '=', value[0])], limit=1)
            if seo_config:
                return False
        return True

    @classmethod
    def remove_rule_from_url_extra(cls, req_page):
        """ Write your custom logic if you want to remove rules other than /shop, /category"""
        return req_page

    @classmethod
    def _custom_seo_rewrite(cls, req_page):
        seo_config_pro = request.env['seo.rewrite.config'].sudo().search(
            [('state', '=', 'enabled'), ('seo_model', '=', 'product')], limit=1)
        seo_config_categ = request.env['seo.rewrite.config'].sudo().search(
            [('state', '=', 'enabled'), ('seo_model', '=', 'category')], limit=1)
        page = ''
        if cls._all_seo_configure_status():
            return req_page
        if not seo_config_categ and req_page.find('/shop/category') >= 0:
            return req_page
        if not seo_config_pro and '/shop/category' not in req_page and req_page.find('/shop/') >= 0:
            return req_page
        website_id = request.env['website'].sudo().get_current_website().sudo()
        redirectObj = request.env['website.rewrite'].sudo()
        try:
            suffix = ''
            if '/page' in req_page:
                page = "/".join(req_page.split('/')[-2:])
                req_page = "/".join(req_page.split("page")[:-1])[:-1]
            if '/shop/category/' in req_page or '/shop/' in req_page:
                req_page = req_page.replace('/shop/category/', '/')
                req_page = req_page.replace('/shop/', '/')
            req_page = cls.remove_rule_from_url_extra(req_page)
            actualUrl = req_page
            urlKey, user_lang = cls._get_remove_lang_code(req_page)
            user_lang_id = request.env['res.lang'].sudo().search([
                '|',
                ('url_code', '=', user_lang),
                ('code', '=', user_lang)
            ], limit=1)

            frontend_lang = request.httprequest.cookies.get('frontend_lang')
            force_lang = False
            url_lang = req_page[1:].split('/')[0]
            if not (user_lang_id.code == frontend_lang or user_lang_id.url_code == frontend_lang):
                force_lang = user_lang_id.code
            if urlKey[1] == '@' and not hasattr(request, 'is_frontend'):
                urlKey = urlKey[2:]
            redirect, lang_specific_value = cls._serve_url_to_redirect(
                urlKey, redirectObj, force_lang, url_lang=force_lang)
            if not user_lang:
                user_lang = redirect.lang_id.code
            if redirect:
                request.update_context(matched_redirect=redirect)
                rewrite_val = redirect.rewrite_val
                if lang_specific_value:
                    urlKey = lang_specific_value
                    # Add requered suffix to url
                    seo_dyn_config = request.env['seo.rewrite.config'].sudo().search(
                        [('state', '=', 'enabled'), ('seo_model', '=', MODEL_MAPPING.get(rewrite_val, [False, False])[0])], limit=1)
                    if seo_dyn_config.use_suffix:
                        suffix = seo_dyn_config.suffix_value
                    if suffix:
                        urlKey += suffix
                url_codes = [lang_setting['url_code']
                             for lang_setting in request.env["res.lang"].sudo()._get_frontend().values()]
                append_lang = url_codes[0] != user_lang or (
                    (cls._get_cuurent_user_lang() != user_lang))
                urlKey = urlKey[1:].replace('/', '__')
                if rewrite_val == 'product.template':
                    if seo_config_categ.use_category_url:
                        urlKey = urlKey.split('__')[-1]
                    if append_lang:
                        redirectUrl = "/shop/{}".format(urlKey)
                    else:
                        redirectUrl = "/shop/{}".format(urlKey)
                    if actualUrl[1] == '@' and not hasattr(request, 'is_frontend'):
                        redirectUrl = '/@'+(redirectUrl)
                    result = {redirectUrl: req_page}
                    request.update_context(hierarchy=result)
                    cls._redirect_to_specified(redirectUrl, redirect)
                    return redirectUrl
                if rewrite_val == 'product.public.category':
                    if seo_config_categ.use_category_hierarchy:
                        urlKey = urlKey.split('__')[-1]
                    if append_lang:
                        redirectUrl = "/shop/category/{}".format(urlKey)
                    else:
                        redirectUrl = "/shop/category/" + urlKey
                    if page:
                        redirectUrl = redirectUrl + "/" + page
                    if actualUrl[1] == '@' and not hasattr(request, 'is_frontend'):
                        redirectUrl = '/@'+(redirectUrl)
                    result = {redirectUrl: req_page}
                    request.update_context(hierarchy=result)
                    cls._redirect_to_specified(redirectUrl, redirect)
                    return redirectUrl
                req_page = cls.custom_match_rewrite_extra(
                    rewrite_val, redirect, urlKey, req_page, actualUrl)
        except Exception as e:
            _logger.info(
                "^^^^^^^^^^^^Exception in custom seo rewrite^^^^^^^^^^^^^^^^: %r", str(e))
        if page:
            req_page = req_page + '/' + page
        return req_page

    @classmethod
    def custom_match_rewrite_extra(cls, rewrite_val, redirect, urlKey, req_page, actualUrl):
        return req_page

    @classmethod
    def validate_hierarchy_url(cls, origional_url, lang=None):
        actual_cat_url = origional_url.replace('/'+lang, '')
        actual_cat_url = actual_cat_url[1:]
        child_cat_list = actual_cat_url.split('/')
        if len(child_cat_list) > 1:
            start = 0
            end = 0
            dic_cat_object = {}
            while (end < len(child_cat_list)):

                cat_object = request.env['product.public.category'].with_context(
                    lang=lang).sudo().search([('url_key', '=', child_cat_list[end])])
                if not cat_object:
                    return origional_url
                dic_cat_object[end] = cat_object.id
                if end > start:
                    parent_cat_id = cat_object.parent_id.id or False
                    if not parent_cat_id or dic_cat_object[start] != parent_cat_id:
                        return origional_url
                    start += 1
                end += 1
        return False

    @classmethod
    def _find_lang_specific_value(cls, url_key, use_category_hierarchy, force_language=False):
        # website = request.env['website'].get_current_website()
        frontend_lang = force_language or request.httprequest.cookies.get(
            'frontend_lang')
        redirectObj = request.env['website.rewrite'].sudo()

        lang_specific_value = False

        domain = [('url_to', '=', '/%s' % (url_key))]
        redirect_id = redirectObj.search(domain, limit=1)

        if redirect_id.id:
            categ_id = request.env['product.public.category'].browse(
                int(redirect_id.record_id))
            if categ_id.id:
                lang_specific_value = '/' + \
                    categ_id.with_context(lang=frontend_lang).url_key

                if use_category_hierarchy:
                    categ_id = categ_id.parent_id
                    while categ_id:
                        lang_url_key = categ_id.with_context(
                            lang=frontend_lang).url_key
                        if lang_url_key:
                            lang_specific_value = '/' + lang_url_key + lang_specific_value
                        categ_id = categ_id.parent_id
        return lang_specific_value

    @classmethod
    def _serve_url_to_redirect(cls, req_page, redirectObj, force_lang=False, url_lang=''):
        try:
            origional_url = req_page
            redirectObjs = lang_specific_value = False
            if req_page[1] == '@' and not hasattr(request, 'is_frontend'):
                req_page = req_page[2:]
            seo_config_categ = request.env['seo.rewrite.config'].sudo().search(
                [('seo_model', '=', 'category')], limit=1)
            seo_config_pro = request.env['seo.rewrite.config'].sudo().search(
                [('seo_model', '=', 'product')], limit=1)
            frontend_lang = request.httprequest.cookies.get('frontend_lang')
            if force_lang:
                frontend_lang = force_lang
            lang_specific_value, child_categ = False, False
            req_page = redirectObj.unsetUrlSuffix(req_page)
            urlKey = ''.join(req_page.split('/')[-1:])
            if seo_config_categ.use_category_url:
                child_categ = ''.join(req_page.split('/')[-2])
            if not urlKey:
                if req_page[-1:] == '/':
                    urlKey = req_page.replace('/', '')

            domain = [('url_to', '=', req_page)]
            if urlKey:
                urlKey = "/" + urlKey
                domain = ['|', ('url_to', '=', req_page),
                          ('url_to', '=', urlKey)]

            current_lang = request.env['res.lang'].sudo()
            if url_lang:
                current_lang = request.env['res.lang'].sudo().search(
                    ['|', ('code', '=', url_lang), ('iso_code', '=', url_lang)])
            elif frontend_lang:
                current_lang = request.env['res.lang'].sudo().search(
                    ['|', ('code', '=', frontend_lang), ('iso_code', '=', frontend_lang)])
            if current_lang:
                domain = expression.AND(
                    [domain, [('lang_id', '=', current_lang.id)]])
            redirectObjs = redirectObj.search(domain, limit=1)
            if not frontend_lang:
                frontend_lang = redirectObjs.lang_id.code
            url_to = redirectObjs.url_to
            lang_specific_value = url_to
            rewrite_val = redirectObjs.rewrite_val
            if rewrite_val == 'product.public.category':
                categ_id = request.env['product.public.category'].browse(
                    int(redirectObjs.record_id)).sudo()
                if seo_config_categ.use_category_hierarchy:
                    if seo_config_categ.use_suffix:
                        origional_url = origional_url.replace(
                            seo_config_categ.suffix_value, '')
                    cat_res = None
                    if not request.httprequest.cookies.get('frontend_lang'):
                        installed_langs = redirectObjs.sudo().get_installed_langs()
                        for rec_lang in installed_langs:
                            cat_res = cls.validate_hierarchy_url(
                                origional_url, rec_lang.code)
                            if not cat_res:
                                frontend_lang = rec_lang.code
                                domain = expression.AND(
                                    [domain, [('lang_id', '=', rec_lang.id)]])
                                redirectObjs = redirectObjs.search(
                                    domain, limit=1)
                                break
                    else:
                        cat_res = cls.validate_hierarchy_url(
                            origional_url, frontend_lang)
                    if cat_res:
                        return request.env['website.rewrite'], origional_url
                if categ_id.id:
                    lang_specific_value = '/' + \
                        categ_id.with_context(lang=frontend_lang).url_key
                    if seo_config_categ and seo_config_categ.use_category_hierarchy:
                        categ_id = categ_id.parent_id
                        while categ_id:
                            lang_url_key = categ_id.with_context(
                                lang=frontend_lang).url_key
                            if lang_url_key:
                                lang_specific_value = '/' + lang_url_key + lang_specific_value
                            categ_id = categ_id.parent_id
            if url_to:
                if url_to[0] == '/':
                    url_to = url_to[1:]
                if seo_config_pro and rewrite_val == 'product.template' and seo_config_categ.use_category_url and not seo_config_categ.use_category_hierarchy and child_categ:
                    split_product_cat_url = origional_url.split('/')
                    split_product_cat_url.pop()
                    last_cat = split_product_cat_url[-1] if split_product_cat_url else None
                    pro_cat_res = cls.validate_hierarchy_url(
                        '/'.join(split_product_cat_url), redirectObjs.lang_id.code)
                    if pro_cat_res:
                        return request.env['website.rewrite'], origional_url
                    if last_cat and last_cat != redirectObjs.lang_id.code:
                        cat_obj = request.env['product.public.category'].with_context(
                            lang=redirectObjs.lang_id.code).sudo().search([('url_key', '=', last_cat)], limit=1)
                        if not cat_obj:
                            return request.env['website.rewrite'], origional_url

                        product_obj = request.env['product.template'].browse(
                            redirectObjs.record_id).sudo()
                        if cat_obj.id not in product_obj.public_categ_ids.parents_and_self.mapped('id'):
                            return request.env['website.rewrite'], origional_url

                    chlid_categ_data = cls._find_lang_specific_value(
                        child_categ, seo_config_categ.use_category_hierarchy, force_language=frontend_lang)
                    lang_specific_value = '%s%s' % (
                        chlid_categ_data, lang_specific_value)
                elif seo_config_pro and rewrite_val == 'product.template' and seo_config_categ.use_category_url and seo_config_categ.use_category_hierarchy and child_categ:
                    split_product_cat_url = origional_url.split('/')
                    split_product_cat_url.pop()
                    last_cat = split_product_cat_url[-1] if split_product_cat_url else None
                    pro_cat_res = cls.validate_hierarchy_url(
                        '/'.join(split_product_cat_url), redirectObjs.lang_id.code)
                    if pro_cat_res:
                        return request.env['website.rewrite'], origional_url
                    if last_cat and last_cat != redirectObjs.lang_id.code:
                        cat_obj = request.env['product.public.category'].with_context(
                            lang=redirectObjs.lang_id.code).sudo().search([('url_key', '=', last_cat)], limit=1)
                        if not cat_obj:
                            return request.env['website.rewrite'], origional_url

                        product_obj = request.env['product.template'].browse(
                            redirectObjs.record_id).sudo()
                        if cat_obj.id not in product_obj.public_categ_ids.parents_and_self.mapped('id'):
                            return request.env['website.rewrite'], origional_url
                    chlid_categ_data = cls._find_lang_specific_value(
                        child_categ, seo_config_categ.use_category_hierarchy, force_language=frontend_lang)
                    lang_specific_value = '%s%s' % (
                        chlid_categ_data, lang_specific_value)
        except Exception as e:
            _logger.info(
                "------Exception--_serve_url_to_redirect----- : %r", e)
        if current_lang.id:
            request.update_context(lang=current_lang.code)
        return redirectObjs, lang_specific_value

    @classmethod
    def _get_custom_url_localized(cls, args, force_default_lang, lang_code, lang):

        path = False
        if args and args.get('product'):
            seo_config_pro = request.env['seo.rewrite.config'].sudo().search(
                [('state', '=', 'enabled'), ('seo_model', '=', 'product')], limit=1)
            if seo_config_pro:
                if force_default_lang:
                    path = args.get('product').with_context(lang=lang_code, switcher_on=True)._get_seo_switcher_url(
                        seo_config_pro.with_context(lang=lang_code))
                else:
                    base_url, path = args.get(
                        'product')._get_product_display_url(seo_config_pro)
                    path = path.replace(f'/{lang.url_code}', '')

        elif args and args.get('category'):
            seo_config_cat = request.env['seo.rewrite.config'].sudo().search(
                [('state', '=', 'enabled'), ('seo_model', '=', 'category')], limit=1)
            if seo_config_cat:
                if force_default_lang:
                    path = args.get('category').with_context(lang=lang_code, switcher_on=True)._get_seo_switcher_url(
                        seo_config_cat.with_context(lang=lang_code))
                else:
                    base_url, path = args.get(
                        'category')._get_category_display_url(seo_config_cat)
                    path = path.replace(f'/{lang.url_code}', '')

        return path

    @classmethod
    def _url_localized(cls,
                       url: str | None = None,
                       lang_code: str | None = None,
                       canonical_domain: str | tuple[str,
                                                     str, str, str, str] | None = None,
                       prefetch_langs: bool = False, force_default_lang: bool = False) -> str:
        '''
        Inheriting this function to manage canonical url formation and language switcher formation.
        '''
        if cls._all_seo_configure_status():
            return super()._url_localized(url=url, lang_code=lang_code, canonical_domain=canonical_domain, prefetch_langs=prefetch_langs, force_default_lang=force_default_lang)
        if not lang_code:
            lang = request.lang
        else:
            lang = request.env['res.lang']._get_data(code=lang_code)

        if not url:
            qs = keep_query()
            url = request.httprequest.path + ('?%s' % qs if qs else '')

        # '/shop/furn-0269-chaise-de-bureau-noire-17?' to
        # '/shop/furn-0269-chaise-de-bureau-noire-17', otherwise -> 404
        url, sep, qs = url.partition('?')

        try:
            # Re-match the controller where the request path routes.
            request.update_context(skip_custom=True)
            rule, args = request.env['ir.http']._match(url)
            request.update_context(skip_custom=False)
            for key, val in list(args.items()):
                if isinstance(val, models.BaseModel):
                    if isinstance(val._uid, RequestUID):
                        args[key] = val = val.with_user(request.uid)
                    if val.env.context.get('lang') != lang.code:
                        args[key] = val = val.with_context(lang=lang.code)
                    if prefetch_langs:
                        args[key] = val = val.with_context(prefetch_langs=True)
            router = http.root.get_db_router(request.db).bind('')
            path = router.build(rule.endpoint, args)
            if args:
                custom_path = cls._get_custom_url_localized(
                    args, force_default_lang, lang_code, lang)
                if custom_path:
                    path = custom_path
        except (NotFound, AccessError, MissingError):
            # The build method returns a quoted URL so convert in this case for consistency.
            path = werkzeug.urls.url_quote_plus(url, safe='/')
        if force_default_lang or lang != request.env['ir.http']._get_default_lang():
            path = f'/{lang.url_code}{path if path != "/" else ""}'

        if canonical_domain:
            # canonical URLs should not have qs
            return werkzeug.urls.url_join(canonical_domain, path)
        return path + sep + qs


class seo_http(website_http):
    _inherit = 'ir.http'

    @classmethod
    def _serve_fallback(cls):
        # serve attachment before
        parent = super(seo_http, cls)._serve_fallback()
        if request.httprequest.path.find('/unsplash') >= 0:
            return parent
        redirect = cls._serve_redirect()
        if redirect and redirect.rewrite_val in [False, 'custom']:
            return parent
        if redirect:
            seo_config = request.env['seo.rewrite.config'].sudo().search(
                [('state', '=', 'enabled'), ('seo_model', '=', MODEL_MAPPING.get(redirect.rewrite_val, ['', ''])[0])], limit=1)
            url_to = redirect.url_to
            model_obj = request.env[redirect.rewrite_val].browse(
                redirect.record_id).sudo()
            if model_obj.exists():
                url_to = model_obj.with_context(
                    lang=redirect.lang_id.code)._get_seo_switcher_url(seo_config)
            if url_to:
                new_redirect = request.redirect(
                    _build_url_w_params(url_to, request.params),
                    code=redirect.redirect_type,
                    local=False)
                new_redirect.set_cookie('frontend_lang', redirect.lang_id.code)
                return new_redirect
        return parent
