# -*- coding: utf-8 -*-
#################################################################################
#
#   Copyright (c) 2015-Present Webkul Software Pvt. Ltd. (<https://webkul.com/>)
#   See LICENSE file for full copyright and licensing details.
#   If not, see <https://store.webkul.com/license.html/>
#
#################################################################################

from odoo import models


class BaseLanguageInstall(models.TransientModel):

    _inherit = "base.language.install"

    def lang_install(self):
        action = super(BaseLanguageInstall, self).lang_install()
        seo_config_pro = self.env['seo.rewrite.config'].sudo().search(
            [('state', '=', 'enabled'), ('seo_model', '=', 'product')], limit=1)
        seo_config_categ = self.env['seo.rewrite.config'].sudo().search(
            [('state', '=', 'enabled'), ('seo_model', '=', 'category')], limit=1)
        if seo_config_pro or seo_config_categ and self.lang_ids:
            for lang_id in self.lang_ids:
                if seo_config_pro:
                    self.env.cr.execute(
                        "UPDATE product_template SET url_redirect_generated = FALSE")
                    seo_config_pro.with_context(
                        current_lang=lang_id.code, new_install_lang=True).generate_product_seo()
                if seo_config_categ:
                    seo_config_categ.with_context(
                        current_lang=lang_id.code, new_install_lang=True).generate_category_seo()
        return action
