from odoo.addons.website_sale.controllers.main import WebsiteSale
from odoo.addons.website.models.ir_http import sitemap_qs2dom
from odoo.http import route, request
from odoo import _
import logging
_logger = logging.getLogger(__name__)


class Website_Sale(WebsiteSale):

    def sitemap_shop(env, rule, qs):
        if not qs or qs.lower() in '/shop':
            yield {'loc': '/shop'}

        Category = env['product.public.category']
        dom = sitemap_qs2dom(qs, '/shop/category', Category._rec_name)
        dom += env['website'].get_current_website().website_domain()
        for cat in Category.search(dom):
            loc = env['website'].get_current_website(
            ).get_seo_category_url(cat)
            if not qs or qs.lower() in loc:
                yield {'loc': loc}

    @route(sitemap=sitemap_shop)
    def shop(self, page=0, category=None, search='', ppg=False, **post):
        result = super(Website_Sale, self).shop(
            page=page, category=category, search=search, ppg=ppg, **post)
        qcontext = result.qcontext
        seo_config = request.env['seo.rewrite.config'].sudo().search(
            [('state', '=', 'enabled'), ('seo_model', '=', 'category')], limit=1)
        if not seo_config:
            return result
        url = "/shop"
        if category:
            cat_obj = request.env['product.public.category'].browse(
                int(category)) if category else request.env['product.public.category']
            cat_obj = cat_obj.sudo()
            if cat_obj.exists():
                url = cat_obj._get_seo_switcher_url(seo_config)
        if not ppg:
            ppg = request.env['website'].get_current_website().shop_ppg or 20
        if qcontext.get("search_count"):
            ppg = int(ppg)
            pager = request.website.pager(url=url, total=qcontext.get(
                "search_count"), page=page, step=ppg, scope=7, url_args=post)
            result.qcontext.update(pager=pager)
        return result

    @route('/remove/extra/params', type='json', auth='public', website=True)
    def remove_extra_params(self):
        seo_config_prod = request.env['seo.rewrite.config'].sudo().search(
            [('state', '=', 'enabled'), ('seo_model', '=', 'product')], limit=1)
        if seo_config_prod.remove_attr_params:
            return True
        else:
            return False

    def _shop_get_query_url_kwargs(self, category, search, min_price, max_price, order=None, tags=None, attribute_value=None, **post):
        res = super(Website_Sale, self)._shop_get_query_url_kwargs(category, search, min_price,
                                                                   max_price, order=order, tags=tags, attribute_value=attribute_value, **post)
        seo_config_prod = request.env['seo.rewrite.config'].sudo().search(
            [('state', '=', 'enabled'), ('seo_model', '=', 'product')], limit=1)
        if seo_config_prod.remove_categ_params and res.get('category'):
            res.pop('category')
        return res
